<?Lassoscript
Define_Type: 'C_DBSpec', -prototype;
	local: 'database' = '';
	local: 'username' = '';
	local: 'password' = '';
	
	Define_Tag: 'onCreate', -required='database', -required='username', -required='password';
		self->'database' = #database;
		self->'username' = #username;
		self->'password' = #password;
	/Define_Tag;
	
	Define_Tag: 'getSpec';
		return: self->toArray;
	/Define_Tag;
	
	Define_Tag: 'onConvert';
		select: params->(get: 1);
			case: 'string';
				return: self->toString;
			case: 'array';
				return: self->toArray;
		/select;
		return: null;
	/Define_Tag;
	
	Define_Tag: 'toString';
		return: self->toArray;
	/Define_Tag;

	Define_Tag: 'toArray';
		return: (array: -database=self->'database', -username=self->'username', -password=self->'password');
	/Define_Tag;
/Define_Type;


Define_Type: 'C_Record', -prototype;
	local: 'key' = null;

	Define_Tag: 'getKey';		//getting the the key instance variable
		return: self->key;
	/Define_Tag;
	
	/* You will rarely use the setKey method outside the custom type hierarchy */
	Define_Tag: 'setKey', -required='key';	//setting the key instance variable
		self->'key' = (integer: #key);
		if: self->'key' == 0;
			self->'key' == null;
		/if;
	/Define_Tag;
	
	Define_Tag: 'hasValidKey';
		return: self->key != null;
	/Define_Tag;
	
	Define_Tag: 'load';
		inline: -search, $gDBspec->getSpec, -maxrecords=1, params;
			records;
				self->LoadX;
			/records;
		/inline;
	/Define_Tag;
	
	Define_Tag: 'loadX';
	/Define_Tag;
	
	Define_Tag: 'save';
		if: self->hasValidKey;	//this is an update operation
			inline: -update, $gDBspec->getSpec, -keyvalue=self->GetKey, params;
			/inline;			
		else;	//this is an add operation
			inline: -add, $gDBspec->getSpec, -keyvalue=self->GetKey, params;
				self->(setKey: -key=keyfield_value);		//it is important to set the key of the object, so the live object is considered valid
			/inline;
		/if;
	/Define_Tag;

	Define_Tag: 'delete';
		if: self->hasValidKey;	//this is an add operation
			inline: -delete, $gDBspec->getSpec, -keyvalue=self->GetKey, params;
				self->(setKey: -key=0);		//it is important to set the key of the object so that it is considered invalid
			/inline;
		/if;
	/Define_Tag;
/Define_Type;


Define_Type: 'C_Contact', 'C_Record', -prototype;
	local: 'firstname' = '';
	local: 'lastname' = '';
	
	Define_Tag: 'load', -required='key';
		if: (integer: #key) != 0;
			self->parent->(load: -table='contact', -keyfield='key', -keyvalue=#key);
		/if;
	/Define_Tag;
	
	Define_Tag: 'loadX';
		self->(setKey: -key=(field: 'key'));
		self->'firstname' = (field: 'firstname');
		self->'lastname' = (field: 'lastname');
	/Define_Tag;
	
	Define_Tag: 'save';
		self->parent->(save: -table='contact', -keyfield='key',
			'firstname'=self->'firstname',
			'lastname'=self->'lastname'
		);
	/Define_Tag;
	
	Define_Tag: 'delete';
		self->parent->(delete: -table='contact', -keyfield='key');
	/Define_Tag;


	Define_Tag: 'setName', -required='firstname', -required='lastname';
		self->'firstname' = #firstname;
		self->'lastname' = #lastname;
	/Define_Tag;
	
	Define_Tag: 'getName';
		return: self->'firstname' + ' ' + self->'lastname';
	/Define_Tag;

	Define_Tag: 'getContactList';
		local: 'result' = array;
		
		local: 'oneRecord' = map;
		inline: -search, $gDBspec->getSpec, -table='contact', -keyfield='key', -maxrecords='all';
			records;
				#oneRecord = C_Contact;
				#oneRecord->loadX;
				#result->(insert: #oneRecord);
			/records;
		/inline;
		return: #result;
	/Define_Tag;
/Define_Type;

?>